$(document).ready(function($){
	if($(".datepicker").length > 0){
		$(".datepicker").datetimepicker({
			timepicker:false,
			format:'Y-m-d',
			closeOnDateSelect:true
		});	
	}
});
// for get all page url
function getPageUrl(fieldVal, fieldId){
	fieldVal = $.trim(fieldVal);
	var replaceVal = fieldVal.replace(/[&\/\\#,+()$~%.'!^":` @_*?<>{}]/g,"-").toLowerCase();
	var replaceVal2 = replaceVal.replace(/-{2,}/g, "-");
	$('#'+fieldId).val(replaceVal2);
}
// get sub category from category id
$(document).ready(function(){
	$("#products-category_id").on("change", function(){
		var currentVal = $(this).val();
		if(currentVal != ""){
			$.ajax({
				type : 'get',
				url : JS_BASE_URL + 'products/getsubcategory',
				data : {category_id : currentVal},
				success : function(response){
					$("#products-sub_category_id").html(response);
				}
			});
		}else{
			$("#products-sub_category_id").html("<option value=''>Select Sub Category</option>");
		}
	});
});

// For upload file
function uploadFile(){
	var property = document.getElementById('imageVal').files[0];
	var image_name = property.name;
	var image_extension = image_name.split('.').pop().toLowerCase();
	if($.inArray(image_extension,['jpeg','jpg','png']) == -1){
		alert("Invalid file type, only jpeg, jpg, png are allowed");
		return false;
	}

	var form_data = new FormData();
	form_data.append("file", property);
	$.ajax({
		url :	JS_BASE_URL + 'staff-master/uploadfile',
		method : 'POST',
		data : form_data,
		contentType : false,
		cache : false,
		processData : false,
		beforeSend : function(){
			$('#imgVal').css('color', 'red');
			$('#imgVal').css('margin-top', '20px');
			$('#imgVal').css('padding', '15px');
			$('#imgVal').text('Uploading...');
		},
		success : function(data){
			$('#imgVal').html(data);
			$('#imgVal').css('margin-top', '0px');
			$('#imgVal').css('padding', '0px');
			alert('File has been uploaded successfully.');
		}
	});
}

// For upload file
function uploadFileImg(fileId, divId, imgSrc){
	if(document.getElementById(fileId).files[0]){
		var property = document.getElementById(fileId).files[0];
		var image_name = property.name;
		var image_extension = image_name.split('.').pop().toLowerCase();
		if($.inArray(image_extension,['jpeg','jpg','png']) == -1){
			alert("Invalid file type, only jpeg, jpg, png are allowed");
			return false;
		}

		var form_data = new FormData();
		form_data.append("file", property);
		$.ajax({
			url :	JS_BASE_URL + 'file/uploadfile',
			method : 'POST',
			data : form_data,
			contentType : false,
			cache : false,
			processData : false,
			beforeSend : function(){
				$('#' + divId).show();
				$('#' + divId).css('margin-left', '53%');
				$('#' + divId).css('clear', 'both');
				$('#' + divId).css('color', 'red');
				$('#' + divId).text('File Uploading...');
			},
			success : function(data){
				$('#' + imgSrc).attr("src", JS_FILE_URL + data);
				$('.' + divId).val(data);
				$('#' + divId).css('margin-left', '53%');
				$('#' + divId).css('clear', 'both');
				alert('File has been uploaded successfully.');
				$('#' + divId).hide();
			}
		});
	}else{
		alert("Please select file.");
		return false;
	}
}

// for view state name
function viewStatename(){
	var stateName = $("#states-p_name").val();
	var stateCode = $("#states-p_code").val();
	if(stateName != "" && stateCode != ""){
		$("#viewState").text(stateName + " - " + stateCode);
	}
}

// for view customer name
function viewCustomername(){
	var customerName = $("#customermaster-name").val();
	var customerType = $("#customermaster-customer_type").val();
	var customerArea = $("#customermaster-area_id").val();
	if(customerName != "" && customerType != "" && customerArea != ""){
		$("#viewCustomer").text(customerName + " - " + customerArea + " - " + customerType);
	}
}

// for view farmer name
function viewFarmername(){
	var farmerName = $("#farmermaster-name_of_farmer").val();
	var farmerArea = $("#farmermaster-area_id").val();
	if(farmerName != "" && farmerArea != ""){
		$("#farmerName").text(farmerName + " - " + farmerArea);
	}
}

// for show hide gst
function showHideGST(obj){
	var gstVal = obj.val();
	if(gstVal == "Yes"){
		$("#customerGst").show();
		$(".customerGst").show();
	}else{
		$("#customerGst").hide();
		$(".customerGst").hide();
	}
}

// for show hide license no.
function showHideLicense(obj){
	var licenseVal = obj.val();
	if(licenseVal == "Yes"){
		$("#customerLicense").show();
	}else{
		$("#customerLicense").hide();
	}
}

// for show hide maximum limit
function showHideMlimit(obj){
	var limitVal = obj.val();
	if(limitVal == "Yes"){
		$("#mlimit").show();
	}else{
		$("#mlimit").hide();
	}
}

// for show hide conversion
function showHideCon(obj){
	var conversionVal = obj.val();
	if(conversionVal == "Yes"){
		$("#conversion").show();
	}else{
		$("#conversion").hide();
	}
}

// for show hide product price
function showHidePrice(obj){
	var productVal = obj.val();
	if(productVal == "Yes"){
		$(".productPrice").show();
	}else{
		$(".productPrice").hide();
	}
}

// for show hide opening fields
function showHideOpeningFields(obj){
	var productVal = obj.val();
	if(productVal == "Yes"){
		$("#not_opening_fields").hide();
		$("#opening_fields").show();
	}else{
		$("#opening_fields").hide();
		$("#not_opening_fields").show();
	}
}