<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Stock Summary';
$this->params['breadcrumbs'][] = $this->title;

?>
<style>.help-block{color:red;}</style>
<div class="main-container">
	<h1 class="mb-0"><?= $this->title; ?></h1>
    <section class="payment_section">
		<?php
		$form = ActiveForm::begin([
					'id' => 'content_form',
					'options' => [
						'enctype' => 'multipart/form-data',
						'class' => 'form-payment',
					],
						]
		);
		if(Yii::$app->session->hasFlash('success')){
		?>  
		<div class="form-group">
			<div class="alert alert-success alert-dismissable">
				 <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
				 <h4><i class="icon fa fa-check"></i>Saved!</h4>
				 <?= Yii::$app->session->getFlash('success') ?>
			</div>
		</div>
		<?php } ?>
		<div class="form-group">
			<?= $form->field($model, 'sr_no')->textInput() ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'type')->dropDownList(['' => 'Select Type', 'Receipt' => 'Receipt', 'Payment' => 'Payment']); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'mode')->dropDownList(['' => 'Select Mode', 'Cash' => 'Cash', 'Cheque' => 'Cheque'], ['onChange' => 'showHide($(this).val());']); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'purpose')->dropDownList(['' => 'Select Purpose', 'Advance' => 'Advance', 'Cash Discount' => 'Cash Discount', 'Normal' => 'Normal'], ['onChange' => 'showPHide($(this).val());']); ?>
		</div>
		<div class="form-group discounts" style="display:none;">
			<?= $form->field($model, 'discount_rate')->textInput() ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'amount')->textInput() ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'date')->textInput(['class' => 'form-control datepicker']); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'remarks')->textInput() ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'otp')->textInput() ?>
		</div>
		<div class="form-group">
			 <?= Html::submitButton('Submit', ['class' => 'btn btn-lg btn-primary form-control', 'name' => 'create-button']) ?>
		</div>
	<?php ActiveForm::end(); ?>
	</section>
</div>
<script>
function showPHide(modeVal){
	$("#paymentreceipt-discount_rate").val('');
	if(modeVal == "Cash Discount"){
		$(".discounts").show();
	}else{
		$(".discounts").hide();
	}
}

function showHide(modeVal){
	$("#paymentreceipt-bank_details_id").val('');
	if(modeVal == "Cheque"){
		$(".banks").show();
	}else{
		$(".banks").hide();
	}
}
</script>