<?php
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;

$this->title = 'Login - Maprole';
$this->params['breadcrumbs'][] = $this->title;
?>
<main>
	<section class="col-md-7 col-sm-9 m-auto">
		<div class="login-panel" >
			<div class="box-heading">
				<h3>Sign In</h3>
			</div>
		<?php
			$form = ActiveForm::begin([
					'id' => 'login-form',
					'class' => 'form-signin',
			]);
		?>
			<div class="form-group">
				<?= $form->field($model, 'email') ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'password')->passwordInput() ?>
				<?= $form->field($model, 'user_type')->hiddenInput(['value' => 2]) ?>
			</div>
			<div class="checkbox mb-3">
				<label>
					<input type="checkbox" checked="checked" class="flipswitch flipswitch1"  value="remember-me"> <span>Remember me</span>
				</label>
			</div>
			<div class="checkbox mb-3">
				<?= Html::submitButton('Sign In', ['class' => 'btn btn-lg btn-primary btn-block form-control', 'name' => 'login-button']) ?>
			</div>
			<div class="form-group text-center">
				<a href="<?php echo BASE_URL; ?>forgotpassword" class="forgotpassword">Forgot your password</a>
			</div>
		<?php ActiveForm::end(); ?>	
		</div>
	</section>
</main>
<style>
.box-heading{
	background: #f44336;
	text-align: center;
	color: #fff;
	text-transform: uppercase;
}
.login-panel {
    margin-top: 30%;
}
.login-panel {
    border: 1px solid #e0e0e0;
}
.box-heading h3 {
    margin: 0;
    font-size: 20px;
    padding: 16px;
    font-weight: bold;
}
#login-form, #forgotpassword {
    margin: 2% 5%;
}
.help-block-error{
	color:red;
}
</style>