<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Purchase Returns';
$this->params['breadcrumbs'][] = $this->title;

?>
<style>.help-block{color:red;}</style>
<div class="main-container">
	<h1 class="mb-0">Purchases Returns</h1>
    <section class="payment_section">
			<?php
			$form = ActiveForm::begin([
						'id' => 'content_form',
						'options' => [
							'enctype' => 'multipart/form-data',
							'class' => 'form-payment',
						],
							]
			);
			if(Yii::$app->session->hasFlash('success')){
			?>  
			<div class="form-group">
				<div class="alert alert-success alert-dismissable">
					 <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
					 <h4><i class="icon fa fa-check"></i>Saved!</h4>
					 <?= Yii::$app->session->getFlash('success') ?>
				</div>
			</div>
			<?php } ?>
			<div class="form-group">
				<?= $form->field($model, 'sr_no')->textInput() ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'books_id')->dropDownList($booksData); ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'date')->textInput(['class' => 'form-control datepicker']); ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'customer_name')->textInput() ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'gst')->dropDownList(['Yes' => 'Yes', 'No' => 'No']); ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'vehicle_number')->textInput() ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'product_id')->dropDownList($productsData); ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'quantity')->textInput() ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'amount_confirm')->dropDownList(['Yes' => 'Yes', 'No' => 'No']); ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'rate')->textInput() ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'amount')->textInput() ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'additional_lines')->textInput() ?>
			</div>
			<div class="form-group">
				<?= $form->field($model, 'remarks')->textInput() ?>
			</div>
			<div class="form-group">
				 <?= Html::submitButton('Submit', ['class' => 'btn btn-lg btn-primary form-control', 'name' => 'create-button']) ?>
			</div>
		<?php ActiveForm::end(); ?>
</section>
</div>