<?php
/* @var $this yii\web\View */
$this->title = 'Sale Order - Maprole';
?>

<div class="main-container">
    <h1 class="mb-0">Sale Order</h1>
	<div class="form-group">
		<div class="alert alert-success alert-dismissable" style="display:none;">
			 <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
			 <h4><i class="icon fa fa-check"></i>Success!</h4>
			 Your order has been placed successfully.
		</div>
	</div>
    <div class="pdp">
		<div class="row pdp-1">
        	<div class="col-md-6 col-sm-6">
				<div class="form-group">
					<select class="form-control" id="productName">
						<option value="">Select product</option>
				<?php 
				if(!empty($allProduct)){
					foreach($allProduct as $value){
				?>		
						<option value="<?= $value['id']; ?>"><?= $value['product_name'].' - '.$value['product_code']; ?></option>
				<?php 
					}
				}
				?>	
					</select>
				</div>
            </div>
			
            <div class="col-md-2 col-sm-4">
            	<div class="form-group">
					<div class="input-group">
						<input type="button" value="-" class="button-minus quantity-btn" data-field="quantity" onClick="removeQty();">
						<input type="number" placeholder="Qty" maxlength="5" id="pQuantity" name="pQuantity" class="quantity-field">
						<input type="button" value="+" class="button-plus quantity-btn" data-field="quantity" onClick="addQty();">
					</div>
				</div>
            </div>
			<div class="col-md-4 col-sm-2">
            	<div class="form-group">
					<button class="btn btn-success btn-xs" type="button" onCLick="return addProduct();">Add</button>
				</div>
            </div>
        </div>
        <div class="table-responsive dtaile-teble">
            <table class="table table-striped table-sm table-bordered mb-0" width="500" id="pTable" style="display:none;">
				<thead class="thead-dark">
					<tr>
						<th>Sr.</th>
						<th>Product</th>
						<th>Quantity</th>
						<th width="70">Delete</th>
					</tr>
				</thead>
				<tbody id="pData"></tbody>
			</table>
        </div>
        <div class=" row mt-5 pdp-b" id="book_order" style="display:none;">
			<div class="col-sm-4">
				<div class="form-group">
					<button class="btn btn-lg btn-primary btn-block form-control" type="button" onClick="return bookOrder();">Book Order</button>
				</div>
			</div>
			<div class="col-sm-4">
				<div class="form-group">
					<a href="<?= BASE_URL; ?>product-listing" class="btn btn-lg btn-danger btn-block form-control" >Cancel</a>
				</div>
			</div>
		</div>
    </div>
</div>
<script>
function addQty(){
	var pQuantity = $("#pQuantity").val();
	if(pQuantity == ""){
		$("#pQuantity").val(1);
	}else{
		$("#pQuantity").val(parseInt(pQuantity) + parseInt(1));
	}
}

function removeQty(){
	var pQuantity = $("#pQuantity").val();
	if(pQuantity > 1){
		$("#pQuantity").val(parseInt(pQuantity) - parseInt(1));
	}
}

var pArray = new Array();
var i = 1;
function addProduct(){
	var productVal = $("#productName :selected").val();
	var productText = $("#productName :selected").text();
	var pQuantity = $("#pQuantity").val();
	if(productVal == ""){
		alert("Please select product name.");
		$("#productName").focus();
		return false;
	}
	if(pQuantity == ""){
		alert("Please enter product quantity.");
		$("#pQuantity").focus();
		return false;
	}
	if ($.inArray(productVal, pArray) !== -1){
		alert("You have already added this product!");
		$("#productName").focus();
		return false;
	}else{
		pArray.push(productVal);	
		var productData = '<tr id="delete_' + productVal + '"><input type="hidden" value="'+productVal+"@@"+pQuantity+'" class="pqData"><td>' + i + '</td><td>' + productText + '</td><td>' + pQuantity + '</td><td onClick="return deleteP(' + productVal + ')"><img src="' + JS_BASE_URL + 'images/delete.jpeg" width="12px" height="auto" class="m-auto"></td></tr>';
		$("#pData").append(productData);
		$("#book_order").show();
		$("#pTable").show();
		$("#productName").val('');
		$("#pQuantity").val('');
		i++;
	}
}

function deleteP(pId){
	if(confirm("Are you want to delete this product?")){
		$("#delete_" + pId).remove();
		pArray = $.grep(pArray, function(n) {
		  return n != pId;
		});
	}else{
		return false;
	}
}

function bookOrder(){
	var pqData = new Array();
	$(".pqData").each(function(){
		pqData.push($(this).val());
	});
	
	if(pArray == ""){
		alert("Please add atleast one product.");
		$("#productName").focus();
		return false;
	}else{
		var csrfToken = $('meta[name="csrf-token"]').attr("content");
		$.ajax({
			type : 'post',
			url : JS_BASE_URL + 'product/placeorder',
			data : 'pqData=' + pqData + '&_csrf-frontend=' + csrfToken,
			success : function(response){
				$(".alert-dismissable").show();
				setTimeout(function() {window.location = JS_BASE_URL + 'product-details'; }, 5000);
			}
		});
	}
}
</script>