<?php
/* @var $this yii\web\View */
$this->title = 'Product Listing - Maprole';
?>

<div class="main-container">
	<h1 class="mb-0">Product Listing</h1>
	<section class="search-sec">
		<form action="#" method="post" novalidate="novalidate">
			<div class="col-lg-12">
				<div class="row">
					<div class="col-lg-3 col-md-3 col-sm-5 p-0">
						<select class="form-control" id="searchFor">
							<option value="product">Product Name</option>
							<option value="usedFor">Used For</option>
							<option value="composition">Compostion</option>
							<option value="brand">Brand</option>
						</select>
					</div>
					<div class="col-lg-3 col-md-3 col-sm-5 p-0">
						<input type="text" class="form-control" id="keyword" placeholder="Search Keyword" value="<?= !empty($_GET['keyword']) ? $_GET['keyword'] : ''; ?>">
					</div>
					<div class="col-lg-2 col-md-2 col-sm-2 p-0">
						<button type="button" class="btn btn-lg btn-primary btn-block form-control" onClick="return getSearch();">Search</button>
					</div>
				</div>
			</div>
		</form>
	</section>
	
    <div class="table-responsive">
		<table class="table table-striped table-sm table-bordered mb-0" width="1000">
			<thead class="thead-dark">
				<tr>
					<th width="80">Sr. No.</th>
					<th>Product Name</th>
					<th width="60">Image</th>
					<th>Used For</th>
					<th>Compostion</th>
					<th>Brand</th>
					<th>Packing</th>
				</tr>
			</thead>
			<tbody>
<?php 
	if(!empty($productData)){
		$count = 1;
		foreach($productData as $value){
?>			
				<tr>
					<td><?= $count; ?></td>
					<td><?= $value['product_name']; ?></td>
					<td><img src="<?= IMG_URL.$value['image']; ?>" width="40" height="auto"></td>
					<td><?= $model->getName($value['product_used_for_id'], 'map_product_used_for_master', 'product_used_for'); ?></td>
					<td><?= $model->getName($value['composition_id'], 'map_composition_master', 'composition'); ?></td>
					<td><?= $model->getName($value['product_of_id'], 'map_product_of_master', 'name_of_brand'); ?></td>
					<td><?= $model->getName($value['product_packing_unit_id'], 'map_packing_unit_master', 'product_packing_units'); ?></td>
				</tr>
<?php 
			$count++;
		}
	}else{
		echo '<tr><td colspan="7" style="text-align:center;font-weight:bold;">No Data Found.</td></tr>';
	}
?>	
			</tbody>
		</table>
	</div>
	<?php if(!empty($productData)){ 
		   echo $this->render("../common/pagging", ["total_records" => $total_records, "page" => $page, 'page_records' => $page_records]);
		}
	?>
	</div>
   
<script>   
function getSearch(){
	var searchFor = $("#searchFor :selected").val();
	var keyword = $("#keyword").val();
	if($("#keyword").val() == ""){
		alert("Please enter search keyword.");
		return false;
	}else{
		fieldVal = $.trim(keyword);
		var replaceVal = fieldVal.replace(/[&\/\\#,+()$~%.'!^":` @_*?<>{}]/g,"-").toLowerCase();
		var replaceVal2 = replaceVal.replace(/-{2,}/g, "-");
		location.href = JS_BASE_URL + "product-listing?searchFor=" + searchFor + "&keyword=" + replaceVal2;
	}
}
</script>   