<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Update Farmer Master';
$this->params['breadcrumbs'][] = $this->title;

?>
<style>.help-block{color:red;}</style>
<div class="main-container">
	<h1 class="mb-0"><?= $this->title; ?></h1>
    <section class="payment_section">
		<?php
		$form = ActiveForm::begin([
					'id' => 'content_form',
					'options' => [
						'enctype' => 'multipart/form-data',
						'class' => 'form-payment',
					],
						]
		);
		if(Yii::$app->session->hasFlash('success')){
		?>  
		<div class="form-group">
			<div class="alert alert-success alert-dismissable">
				 <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
				 <h4><i class="icon fa fa-check"></i>Saved!</h4>
				 <?= Yii::$app->session->getFlash('success') ?>
			</div>
		</div>
		<?php } ?>
		<div class="form-group">
			<?= $form->field($model, 'name_of_farmer')->textInput(["onKeyup" => "viewFarmername()"]) ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'area_id')->dropDownList($areaData) ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'farmer_type')->dropDownList($farmerType) ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'contact_no')->textInput(['maxlength' => 11]) ?>
		</div>
		<div class="form-group">
			<div class="form-group field-farmermaster-name_of_farmer required">
				<label>Name for display :- <span id="farmerName"></span></label>
			</div>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'address')->textarea(['rows' => 3]); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'space')->textInput(['maxlength' => 11]) ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'status')->dropDownList(['' => 'Select Status', 'Active' => 'Active', 'Inactive' => 'Inactive']); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'image')->fileInput(['id' => 'fileId']); ?>
		</div>
		<div class="form-group">
			<input type="button" value="Upload" class="btn btn-primary" onClick="return uploadFileImg('fileId','divId','imgSrc');">
			<input type="hidden" name="upload_file" class="divId" value="<?= !empty($model->image) ? $model->image : ''; ?>">
		</div>
		<div id="divId"></div>
		
		<div class="form-group" style="border: 1px solid #ddd;box-shadow: 2px 1px 6px -1px;clear:both;width:145px;" id="imgVal">
			<img src="<?= !empty($model->image) ? IMG_URL . $model->image : BASE_URL.'images/no-profile.jpg'; ?>" width="145" height="130" id="imgSrc"/>
		</div>
		<div class="form-group">
			 <?= Html::submitButton('Update', ['class' => 'btn btn-lg btn-primary form-control', 'name' => 'update-button']) ?>
			 
			 <?= Html::a('Cancel', ['/farmer-master'], ['class' => 'btn btn-lg btn-danger form-control']) ?>
		</div>
<?php ActiveForm::end(); ?>
</section>
</div>