<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Update Customer Master';
$this->params['breadcrumbs'][] = $this->title;

?>
<style>.help-block{color:red;}</style>
<div class="main-container">
	<h1 class="mb-0"><?= $this->title; ?></h1>
    <section class="payment_section">
		<?php
		$form = ActiveForm::begin([
					'id' => 'content_form',
					'options' => [
						'enctype' => 'multipart/form-data',
						'class' => 'form-payment',
					],
						]
		);
		if(Yii::$app->session->hasFlash('success')){
		?>  
		<div class="form-group">
			<div class="alert alert-success alert-dismissable">
				 <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
				 <h4><i class="icon fa fa-check"></i>Saved!</h4>
				 <?= Yii::$app->session->getFlash('success') ?>
			</div>
		</div>
		<?php } ?>
		<div class="form-group">
			<?= $form->field($model, 'name')->textInput(["onKeyup" => "viewCustomername()"]) ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'customer_code')->textInput() ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'customer_type')->dropDownList($customerType); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'area_id')->dropDownList($areaData); ?>
		</div>
		<div class="form-group">
			<div class="form-group field-states-p_code required has-success">
				<label class="control-label"><b>View Customer :-</b> <span id="viewCustomer"></span></label>
			</div>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'email_id')->textInput(['autocomplete' => 'off']) ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'contact_no')->textInput(['maxlength' => 11]) ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'whatsapp_contact_no')->textInput(['maxlength' => 11]) ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'aadhaar_card_no')->textInput(['autocomplete' => 'off']) ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'pan_card_no')->textInput() ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'opening_balance')->textInput(['autocomplete' => 'off']) ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'password')->passwordInput() ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'confirm_password')->passwordInput() ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'address')->textarea(['rows' => 3]); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'staff_assign_id')->dropDownList($staffData); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'maximum_limit')->dropDownList(['' => 'Select Maximum Limit','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'showHideMlimit($(this).val());']); ?>
		</div>
		<div class="form-group mlimit" style="display:none;">
			<?= $form->field($model, 'vegetable')->textInput() ?>
		</div>
		<div class="form-group mlimit" style="display:none;">
			<?= $form->field($model, 'clothing')->textInput() ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'gst_applicable')->dropDownList(['' => 'Select Gst Applicable','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'showHideGST($(this).val());']); ?>
		</div>
		<div class="form-group" id="customerGst" style="display:none;">
			<?= $form->field($model, 'gst_no')->textInput() ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'is_licenses_applicable')->dropDownList(['' => 'Select Licenses Applicable','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'showHideLicense($(this).val());']); ?>
		</div>
		<div class="form-group" id="customerLicense" style="display:none;">
			<?= $form->field($model, 'license_no')->dropDownList(['' => 'Select Licenses','Yes' => 'Yes', 'No' => 'No']); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'power_to_join_farmer')->dropDownList(['' => 'Select','Yes' => 'Yes', 'No' => 'No']); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'status')->dropDownList(['Active' => 'Active', 'Inactive' => 'Inactive']); ?>
		</div>
		<div class="form-group">
			<?= $form->field($model, 'photo')->fileInput(['id' => 'fileId']); ?>
		</div>
		<div class="form-group" style="margin-top:25px;"><input type="button" value="Upload" class="btn btn-primary" onClick="return uploadFileImg('fileId','divId','imgSrc');"></div>
		<div id="divId"></div>
		<input type="hidden" name="upload_file" class="divId" value="<?= !empty($model->photo) ? $model->photo : ''; ?>">
		<div class="form-group" style="border: 1px solid #ddd;box-shadow: 2px 1px 6px -1px;width:145px;" id="imgVal">
			<img src="<?= !empty($model->photo) ? IMG_URL . $model->photo : BASE_URL.'images/no-profile.jpg'; ?>" width="145" height="100" id="imgSrc"/>
		</div>
		<div class="form-group">
			 <?= Html::submitButton('Update', ['class' => 'btn btn-lg btn-primary form-control', 'name' => 'update-button']) ?>
			 
			 <?= Html::a('Cancel', ['/customer-master'], ['class' => 'btn btn-lg btn-danger form-control']) ?>
		</div>
<?php ActiveForm::end(); ?>
    </section>
</div>

<link href="<?= BASE_URL; ?>css/select2.min.css" rel="stylesheet" />
<script src="<?= BASE_URL; ?>js/select2.min.js"></script>
<script type="text/javascript">
$(document).ready(function() {
	$.noConflict();
	$("#ownmaster-state_code").select2().on("change", function (e) {
		getStateCode();
	});
});
</script>
