<?php
/* @var $this yii\web\View */
$this->title = 'Customers Listing - Maprole';
?>

<div class="main-container">
	<h1 class="mb-0">Customers Listing</h1>
	<section class="search-sec">
		<form action="#" method="post" novalidate="novalidate">
			<div class="col-lg-12">
				<div class="row">
					<div class="col-lg-3 col-md-3 col-sm-5 p-0">
						<input type="text" class="form-control" id="searchValue" placeholder="Search Keyword" value="<?= !empty($_GET['keyword']) ? $_GET['keyword'] : ''; ?>">
					</div>
					<div class="col-lg-2 col-md-2 col-sm-2 p-0">
						<button type="button" class="btn btn-lg btn-primary btn-block form-control" onClick="searchVal();">Search</button>
					</div>
					<div class="col-lg-2 col-md-2 col-sm-2 p-0">
						<div class="form-group">
							<button type="button" onClick="location.href='<?= BASE_URL; ?>customer-master/create'" class="btn btn-lg btn-success btn-block form-control">Add New</button>
						</div>
					</div>
				</div>
			</div>
		</form>
	</section>
	
    <div class="table-responsive">
		<table class="table table-striped table-sm table-bordered mb-0" width="1000">
			<thead class="thead-dark">
			<tr>
				<th width="80">Customer Code</th>
				<th>Customer Name</th>
				<th>Email Id</th>
				<th>Contact No.</th>
				<th>Aadhaar Card</th>
				<th>Pan Card</th>
				<th>Action</th>
			</tr>
			</thead>
			<tbody>
<?php 
if(!empty($dataProvider)){
	$count = 1;
	foreach($dataProvider as $value){
?>		
			<tr>
				<td><?= $value['customer_code']; ?></td>
				<td><?= $value['name']; ?></td>
				<td><?= $value['email_id']; ?></td>
				<td><?= $value['contact_no']; ?></td>
				<td><?= $value['aadhaar_card_no']; ?></td>
				<td><?= $value['pan_card_no']; ?></td>
				<td><a href="<?= BASE_URL; ?>customer-master/update?id=<?= $value['id']; ?>"><i class="fa fa-edit fa-fw fontSize20"></i></a></td>
			</tr>
<?php 
		$count++;
	}
}
?>	
			</tbody>
		</table>
	</div>
	<?php if(!empty($dataProvider)){ 
		   echo $this->render("../common/pagging", ["total_records" => $total_records, "page" => $page, 'page_records' => $page_records]);
		}
	?>
</div>
<script>
function searchVal(){
	var fieldVal = $("#searchValue").val();
	if(fieldVal == ""){
		alert("Please enter search keyword.");
		$("#searchValue").focus();
		return false;
	}else{
		fieldVal = $.trim(fieldVal);
		var replaceVal = fieldVal.replace(/[&\/\\#,+()$~%.'!^":` @_*?<>{}]/g,"-").toLowerCase();
		var replaceVal2 = replaceVal.replace(/-{2,}/g, "-");
		window.location = JS_BASE_URL + 'customer-master?keyword=' + replaceVal2;
	}
}
</script>