<?php 
if ($total_records > $page_records) {
	$totalPages = ceil($total_records / $page_records);
	if (empty($page) || $page == 0) {
		$page = 1;
	}
	$explode = explode('?', $_SERVER["REQUEST_URI"]);
	$next = 'javascript:void(0);';
	$nextClass = 'disabled';
	$previous = 'javascript:void(0);';
	$previousClass = 'disabled';
	if ($page < $totalPages) {
		$next = $explode[0] . '?page=' . ($page + 1);
		$nextClass = '';
	}
	if ($page > 1) {
		$previous = $explode[0] . '?page=' . ($page - 1);
		$previousClass = '';
	}
?>
<nav aria-label="Page navigation" class="mt-4">
	<ul class="pagination justify-content-end">
		<li class="page-item <?= $previousClass; ?>">
			<a class="page-link" href="<?= $previous; ?>" tabindex="-1">Previous</a>
		</li>
		<?php
            $countPage = 1;
            $pageCount = $page;
            if ($totalPages > 4) {
                $total_page = ($totalPages - 4);
                if ($pageCount >= $total_page) {
                    $pageCount = $total_page;
                }
            }
            for ($i = $pageCount; $i <= $totalPages; $i++) {
                $active = '';
                if ($i == $page) {
                    $active = 'class="active"';
                }
                ?>
                <li class="page-item"><a class="page-link" href="<?= $explode[0] . '?page=' . $i; ?>"><?= $i; ?></a></li>
                <?php
                $countPage++;
                if ($countPage == 6) {
                    break;
                }
            }
            ?>
		<li class="page-item <?= $nextClass; ?>">
			<a class="page-link" href="<?= $next; ?>">Next</a>
		</li>
	</ul>
</nav>
<?php 
}
?>