<?php

namespace frontend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class FarmerMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_farmer_master';
    }

	public function rules() {
        return [
            [['name_of_farmer', 'farmer_type', 'area_id', 'space', 'contact_no', 'address', 'status'], 'required'],
			[['name_of_farmer', 'farmer_type', 'image', 'area_id', 'space', 'contact_no', 'address', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name_of_farmer' => 'Name of Farmer',
            'address' => 'Address',
            'farmer_type' => 'Farmer Type',
            'contact_no' => 'Contact Number',
            'area_id' => 'Area',
            'space' => 'Space',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach FarmerMaster data and listing
    public function search($params) {
		$query = FarmerMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name_of_farmer', $this->name_of_farmer]);
		$query->andFilterWhere(['like', 'farmer_type', $this->farmer_type]);
		$query->andFilterWhere(['like', 'contact_no', $this->contact_no]);
		$query->andFilterWhere(['like', 'address', $this->address]);
		
        return $dataProvider;
    }

}
