<?php

namespace frontend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class CustomerMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_customer_master';
    }

	public function rules() {
        return [
            [['name', 'address', 'email_id', 'contact_no', 'area_id', 'gst_applicable', 'is_licenses_applicable', 'customer_type', 'aadhaar_card_no', 'pan_card_no', 'staff_assign_id', 'opening_balance', 'password', 'confirm_password', 'whatsapp_contact_no'], 'required'],
			[['email_id'], 'email'],
			[['email_id'], 'unique'],
			[['contact_no'], 'number'],
			[['whatsapp_contact_no'], 'number'],
			[['name', 'address', 'email_id', 'contact_no', 'area_id', 'gst_applicable', 'is_licenses_applicable', 'customer_type', 'aadhaar_card_no', 'pan_card_no', 'staff_assign_id', 'opening_balance', 'password', 'confirm_password', 'whatsapp_contact_no', 'license_no', 'gst_no'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name' => 'Customer Name',
            'address' => 'Address',
            'staff_assign_id' => 'Assign Staff',
            'email_id' => 'Email Id',
            'contact_no' => 'Contact Number',
            'whatsapp_contact_no' => 'WhatsApp Contact Number',
            'area_id' => 'Area',
			'gst_applicable' => 'Is GST Applicable',
			'is_licenses_applicable' => 'Is Licenses Applicable',
            'gst_no' => 'GST Number',
            'license_no' => 'Licenses Number',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach CustomerMaster data and listing
    public function search($params) {
		$query = CustomerMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name', $this->name]);
		$query->andFilterWhere(['like', 'email_id', $this->email_id]);
		$query->andFilterWhere(['like', 'contact_no', $this->contact_no]);
		$query->andFilterWhere(['like', 'aadhaar_card_no', $this->aadhaar_card_no]);
		$query->andFilterWhere(['like', 'pan_card_no', $this->pan_card_no]);
		
        return $dataProvider;
    }

}
