<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\PurchaseOrder;
use backend\models\ProductOf;
use backend\models\Utility;

/**
 * PurchasesOrder controller
 */
class PurchasesOrderController extends Controller
{
	/**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
				'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['index'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays PurchasesOrder listing page.
     *
     * @return mixed
     */
    public function actionIndex(){
		$model = new PurchaseOrder();
		$modelProduct = new ProductOf();
		$booksData = $modelProduct->getBooks();
		$productsData = $modelProduct->getProducts();
		if(!empty($_POST['PurchaseOrder'])){
			$model->attributes = $_POST['PurchaseOrder'];
			$model->created_on = new \yii\db\Expression('now()');
			if(isset(Yii::$app->user->identity->id)){
				$model->created_by = Yii::$app->user->identity->id;
			}
			if ($model->validate()) {
				$model->save();
				Yii::$app->session->setFlash('success', "Purchase order has been created Successfully.");
				return $this->redirect(['/purchases-order']);
			}
		}		
        return $this->render('index', [
				'model' => $model,
				'booksData' => $booksData,
				'productsData' => $productsData
		]);
    }
	
}
