<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\ProductMaster;

/**
 * Product controller
 */
class ProductController extends Controller
{
	/**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
				'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['index', 'productdetails', 'placeorder'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays product listing page.
     *
     * @return mixed
     */
    public function actionIndex(){
		$model = new ProductMaster();
		$page = !empty($_GET['page']) ? $_GET['page'] : 1;
		$page_records = 10;
		$total_records = ProductMaster::find()->where(['status' => 'Active'])->count();
		if(!empty($_GET['searchFor']) && !empty($_GET['keyword'])){
			$productData = $model->getProductData($_GET['searchFor'], $_GET['keyword']);
		}else{
			$productData = $model->getAllProductData($page,$page_records);
		}
		
		return $this->render('index',[
			'model' => $model,
			'page' => $page,
			'productData' => $productData,
			'total_records' => $total_records,
			'page_records' => $page_records
		]);
    }

    /**
     * Product Details.
     *
     * @return mixed
     */
    public function actionProductdetails(){
		$model = new ProductMaster();
		$allProduct = $model->getAllProducts();
        
		return $this->render('productdetails', [
			'model' => $model,
			'allProduct' => $allProduct
		]);
    }
	
	/**
     * Place order
     *
     * @return mixed
     */
    public function actionPlaceorder(){
		$model = new ProductMaster();
		if(!empty($_POST['pqData'])){
			$explode = explode(",", $_POST['pqData']);
			$user_id = Yii::$app->user->identity->id;
			$place_order_id = $model->placeProductOrder($user_id);
			foreach($explode as $value){
				$ids = explode("@@", $value);
				$product_id = !empty($ids[0]) ? $ids[0] : '';
				$product_qty = !empty($ids[1]) ? $ids[1] : '';
				$model->placeOrder($product_id,$product_qty,$place_order_id);
			}
		}
    }
	
}
