<?php
namespace frontend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use backend\models\FarmerMaster;
use backend\models\StaffMaster;
use backend\models\Utility;

/**
 * FarmerMaster controller
 */
class FarmerMasterController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
				'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays FarmerMaster listing.
     *
     * @return string
     */
    public function actionIndex(){
        $searchModel = new FarmerMaster();
		$page_records = 10;
		$page = !empty($_GET['page']) ? $_GET['page'] : 1;
		$keyword = !empty($_GET['keyword']) ? $_GET['keyword'] : '';
		$total_records = FarmerMaster::find()->where(['status' => 'Active'])->count();
		$data = $searchModel->getAllFarmerData($keyword);
		
        return $this->render('index', [
				'data' => $data,
				'page_records' => $page_records,
				'page' => $page,
				'model' => $searchModel,
				'keyword' => $keyword,
				'total_records' => $total_records
		]);
    }
	
	// For create FarmerMaster
	public function actionCreate(){
		$model = new FarmerMaster();
		$modelStaff = new StaffMaster();
		$areaData = $modelStaff->getAreaData();
		$farmerType = $model->getFarmerType();
		if(!empty($_POST['FarmerMaster'])){
			$model->attributes = $_POST['FarmerMaster'];
			$model->image = !empty($_POST['upload_file']) ? $_POST['upload_file'] : '';
			$model->created_on = new \yii\db\Expression('now()');
			if(isset(Yii::$app->user->identity->id)){
				$model->created_by = Yii::$app->user->identity->id;
			}
			if ($model->validate()) {
				$model->save();
				Yii::$app->session->setFlash('success', "Farmer has been created Successfully.");
				return $this->redirect(['/farmer-master']);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'farmerType' => $farmerType,
				'areaData' => $areaData
		]);
    }
	
	
	// For update FarmerMaster data
	public function actionUpdate($id=''){
		$modelStaff = new StaffMaster();
		$modelFarmer = new FarmerMaster();
		$areaData = $modelStaff->getAreaData();
		$farmerType = $modelFarmer->getFarmerType();
		$model = $this->findModel($id);
		if(!empty($_POST['FarmerMaster'])){
			$model->attributes = $_POST['FarmerMaster'];
			$model->image = !empty($_POST['upload_file']) ? $_POST['upload_file'] : '';
			$model->updated_on = new \yii\db\Expression('now()');
			if(isset(Yii::$app->user->identity->id)){
				$model->updated_by = Yii::$app->user->identity->id;
			}
			if ($model->validate()) {
				$model->save();
				Yii::$app->session->setFlash('success', "Farmer has been updated Successfully.");
				return $this->redirect(['/farmer-master']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'areaData' => $areaData,
				'farmerType' => $farmerType,
				'id' => $id
		]);
    }
	
	// For get FarmerMaster data from id
	protected function findModel($id) {
        if (($model = FarmerMaster::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
