<?php
namespace frontend\controllers;

use Yii;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Security;
use backend\models\CustomerMaster;
use backend\models\StaffMaster;
use backend\models\Utility;

/**
 * CustomerMaster controller
 */
class CustomerMasterController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
				'rules' => [
                    [
                        'actions' => ['error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['update', 'index', 'create'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                // 'actions' => [
                    // 'logout' => ['post'],
                // ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays CustomerMaster listing.
     *
     * @return string
     */
    public function actionIndex(){
        $model = new CustomerMaster();
		$page = !empty($_GET['page']) ? $_GET['page'] : 1;
		$page_records = 10;
		$total_records = CustomerMaster::find()->where(['status' => 'Active'])->count();
		if(!empty($_GET['keyword'])){
			$dataProvider = $model->getSearchCustData($_GET['keyword']);
		}else{
			$dataProvider = $model->getAllCustData($page,$page_records);
		}
		
        return $this->render('index', [
				'model' => $model,
				'page_records' => $page_records,
				'total_records' => $total_records,
				'page' => $page,
				'dataProvider' => $dataProvider
		]);
    }
	
	// For create CustomerMaster
	public function actionCreate(){
		$model = new CustomerMaster();
		$modelStaff = new StaffMaster();
		$areaData = $modelStaff->getAreaData();
		$staffData = $modelStaff->getStaffData();
		$customerType = $model->getCustomerType();
		if(!empty($_POST['CustomerMaster'])){
			$model->attributes = $_POST['CustomerMaster'];
			$model->created_on = new \yii\db\Expression('now()');
			$model->created_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				Yii::$app->session->setFlash('success', "Customer has been created Successfully.");
				return $this->redirect(['/cutomer-master']);
			}
		}		
        return $this->render('create', [
				'model' => $model,
				'customerType' => $customerType,
				'staffData' => $staffData,
				'areaData' => $areaData
		]);
    }
	
	
	// For update CustomerMaster data
	public function actionUpdate($id=''){
		$model = $this->findModel($id);
		$modelCustomer = new CustomerMaster();
		$modelStaff = new StaffMaster();
		$areaData = $modelStaff->getAreaData();
		$staffData = $modelStaff->getStaffData();
		$customerType = $modelCustomer->getCustomerType();
		if(!empty($_POST['CustomerMaster'])){
			$model->attributes = $_POST['CustomerMaster'];
			$model->updated_on = new \yii\db\Expression('now()');
			$model->updated_by = Yii::$app->user->identity->id;
			if ($model->validate()) {
				$model->save();
				Yii::$app->session->setFlash('success', "Customer has been updated Successfully.");
				return $this->redirect(['/cutomer-master']);
			}
		}
		return $this->render('update', [
				'model' => $model,
				'id' => $id,
				'customerType' => $customerType,
				'staffData' => $staffData,
				'areaData' => $areaData
		]);
    }
	
	// For get CustomerMaster data from id
	protected function findModel($id) {
        if (($model = CustomerMaster::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

}
