<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'Vehicle Number List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>vehicle-number/create" title="Create Vehicle Number">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'vehicle_number',
						'value' => 'vehicle_number',
						'filter' => true,
					],
					[
						'attribute' => 'driver_id',
						'value' => function($model){
							return $model->getDriverName($model->driver_id);
						},
						'filter' => true,
					],
					[
						'attribute' => 'owner_id',
						'value' => function($model){
							return $model->getOwnerName($model->owner_id);
						},
						'filter' => true,
					],
					[
						'attribute' => 'model',
						'value' => 'model',
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'value' => 'status',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>