<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Update State';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="col-lg-10 col-lg-offset-1 mainDiv">
    <div class="panel-default table-bordered">
         <div class="panel-heading">
            <?php echo $this->title ?>
            <div class="menuLink">
                <a href="<?php echo BASE_URL; ?>states" title="State List">
                    <i class="fa fa-list-ul fa-fw" style="font-size: 18px !important;"></i>
                </a>
            </div>
        </div>
        <div class="panel-body">
			<div class="form-container">
                <?php
                $form = ActiveForm::begin([
                            'id' => 'content_form',
                            'options' => [
                                'enctype' => 'multipart/form-data',
                            ],
                                ]
                );
                ?>  
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'p_code')->textInput() ?>      
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'p_name')->textInput() ?>      
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group field-states-p_code required has-success">
									<label class="control-label"><b>View State :-</b> <span id="viewState"></span></label>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group">
									<?= Html::submitButton('Update', ['class' => 'btn btn-primary', 'name' => 'update-button']) ?>
									<?= Html::a('Cancel', ['/states'], ['class' => 'btn btn-danger']) ?>
								</div>
							</div>
						</div>
					</div>
                </div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>
