<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;

$this->title = 'States List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>states/create" title="Create State">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [
					[
						'attribute' => 'p_code',
						'value' => 'p_code',
						'filter' => true,
					],
					[
						'attribute' => 'p_name',
						'value' => 'p_name',
						'filter' => true,
					],
					[
						'attribute' => 'p_status',
						'format' => 'raw',
						'contentOptions' => ['style' => 'width:110px;'],
						'value' => function($model){
							$check = "";
							if($model->p_status == "Active"){
								$check = "checked='checked'";	
							}
							return '<input type="checkbox" table="ac_states" class="statusBtn" '.$check.' idVal="'.$model->p_code.'">';
						},
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>