<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'Staff Master List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>staff-master/create" title="Create Staff Master">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'name_of_staff',
						'value' => 'name_of_staff',
						'filter' => true,
					],
					[
						'attribute' => 'own_master_id',
						'value' => function($model){
							return $model->getCompanyName($model->own_master_id);
						},
						'filter' => true,
					],
					[
						'attribute' => 'email_id',
						'value' => 'email_id',
						'filter' => true,
					],
					[
						'attribute' => 'contact_no',
						'value' => 'contact_no',
						'filter' => true,
					],
					[
						'attribute' => 'aadhaar_card_no',
						'value' => 'aadhaar_card_no',
						'filter' => true,
					],
					[
						'attribute' => 'pan_card_no',
						'value' => 'pan_card_no',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>