<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Create Staff Master';
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="col-lg-10 col-lg-offset-1 mainDiv">
    <div class=" panel-default table-bordered">
         <div class="panel-heading">
            <?php echo $this->title ?>
            <div class="menuLink">
                <a href="<?php echo BASE_URL; ?>staff-master" title="Staff Master List">
                    <i class="fa fa-list-ul fa-fw" style="font-size: 18px !important;"></i>
                </a>
            </div>
        </div>
        <div class="panel-body">
			<div class="form-container">
                <?php
                $form = ActiveForm::begin([
                            'id' => 'content_form',
                            'options' => [
                                'enctype' => 'multipart/form-data',
                            ],
                                ]
                );
				?>  
					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'name_of_staff')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'email_id')->textInput(['autocomplete' => 'off']) ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'contact_no')->textInput(['maxlength' => 11]) ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'whatsapp_contact_no')->textInput(['maxlength' => 11]) ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'own_master_id')->dropDownList($companyData) ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'area_id')->dropDownList($areaData) ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'aadhaar_card_no')->textInput(['maxlength' => 11]) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'pan_card_no')->textInput(['maxlength' => 11]) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'password')->passwordInput(['autocomplete' => 'off']); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'confirm_password')->passwordInput(['autocomplete' => 'off']); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<?= $form->field($model, 'address')->textarea(['rows' => 3]); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group" style="float:left;">
								<?= $form->field($model, 'photo')->fileInput(['id' => 'fileId']); ?>
							</div>
							<div style="float:left;margin-top:25px;"><input type="button" value="Upload" class="btn btn-primary" onClick="return uploadFileImg('fileId','divId','imgSrc');"></div><br/>
							<div id="divId"></div>
							<input type="hidden" name="upload_file" class="divId">
						</div>
						<div class="col-sm-6">
							<div class="form-group" style="border: 1px solid #ddd;box-shadow: 2px 1px 6px -1px;float:left;margin-left:20px;" id="imgVal">
								<img src="<?= BASE_URL.'images/no-profile.jpg'; ?>" width="145" height="100" id="imgSrc"/>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'status')->dropDownList(['Active' => 'Active', 'Inactive' => 'Inactive']); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<?= $form->field($model, 'staff_rights')->checkboxList(['Customer' => 'Customer', 'Farmer' => 'Farmer', 'View Order / Take Order' => 'View Order / Take Order', 'Stock Options' => 'Stock Options', 'View Schemes' => 'View Schemes', 'Sales Return' => 'Sales Return', 'Collect Payments' => 'Collect Payments', 'IDST' => 'IDST']) ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group">
									 <?= Html::submitButton('Create', ['class' => 'btn btn-primary', 'name' => 'create-button']) ?>
									 
									 <?= Html::a('Cancel', ['/staff-master'], ['class' => 'btn btn-danger']) ?>
								</div>
							</div>
						</div>
					</div>
				</div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>

<link href="<?= BASE_URL; ?>css/select2.min.css" rel="stylesheet" />
<script src="<?= BASE_URL; ?>js/select2.min.js"></script>
<script type="text/javascript">
$(document).ready(function() {
	$.noConflict();
	$("#ownmaster-state_code").select2().on("change", function (e) {
		getStateCode();
	});
});
</script>
