<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'Scheme Set List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>scheme/create" title="Create Scheme Set">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'scheme_name',
						'value' => 'scheme_name',
						'filter' => true,
					],
					[
						'attribute' => 'product_id',
						'value' => function($model){
							return Utility::getProductName($model->product_id);
						},
						'filter' => true,
					],
					[
						'attribute' => 'total_quantity',
						'value' => 'total_quantity',
						'filter' => true,
					],
					[
						'attribute' => 'validity_from',
						'value' => 'validity_from',
						'filter' => true,
					],
					[
						'attribute' => 'validity_to',
						'value' => 'validity_to',
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'value' => 'status',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>