<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'Sales Returns List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>sales-returns/create" title="Create Sales Returns">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'sr_no',
						'value' => 'sr_no',
						'filter' => true,
					],
					[
						'attribute' => 'books_id',
						'value' => function($model){
							return Utility::getBookName($model->books_id);
						},
						'filter' => true,
					],
					[
						'attribute' => 'product_id',
						'value' => function($model){
							return Utility::getProductName($model->product_id);
						},
						'filter' => true,
					],
					[
						'attribute' => 'customer_name',
						'value' => 'customer_name',
						'filter' => true,
					],
					[
						'attribute' => 'date',
						'value' => function($model){
							return Utility::getDateFormat($model->date);
						},
						'filter' => true,
					],
					[
						'attribute' => 'quantity',
						'value' => 'quantity',
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'value' => 'status',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>