<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Create Purchase Returns';
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="col-lg-10 col-lg-offset-1 mainDiv">
    <div class=" panel-default table-bordered">
         <div class="panel-heading">
            <?php echo $this->title ?>
            <div class="menuLink">
                <a href="<?php echo BASE_URL; ?>purchase-returns" title="Purchase Returns List">
                    <i class="fa fa-list-ul fa-fw" style="font-size: 18px !important;"></i>
                </a>
            </div>
        </div>
        <div class="panel-body">
			<div class="form-container">
                <?php
                $form = ActiveForm::begin([
                            'id' => 'content_form',
                            'options' => [
                                'enctype' => 'multipart/form-data',
                            ],
                                ]
                );
				?>  
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'sr_no')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'customer_name')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'books_id')->dropDownList($booksData); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'product_id')->dropDownList($productsData); ?>
							</div>
						</div>
					</div>	
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'customer_name')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'amount')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'amount_confirm')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'rate')->textInput() ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'quantity')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'gst')->dropDownList(['Yes' => 'Yes', 'No' => 'No']); ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'vehicle_number')->textInput() ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'remarks')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'additional_lines')->textInput() ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'date')->textInput(['class' => 'form-control datepicker']); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group">
									 <?= Html::submitButton('Create', ['class' => 'btn btn-primary', 'name' => 'create-button']) ?>
									 
									 <?= Html::a('Cancel', ['/purchase-returns'], ['class' => 'btn btn-danger']) ?>
								</div>
							</div>
						</div>
					</div>
				</div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>