<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Update Product';
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="col-lg-10 col-lg-offset-1 mainDiv">
    <div class=" panel-default table-bordered">
         <div class="panel-heading">
            <?php echo $this->title ?>
            <div class="menuLink">
                <a href="<?php echo BASE_URL; ?>product-master" title="Product List">
                    <i class="fa fa-list-ul fa-fw" style="font-size: 18px !important;"></i>
                </a>
            </div>
        </div>
        <div class="panel-body">
			<div class="form-container">
                <?php
                $form = ActiveForm::begin([
                            'id' => 'content_form',
                            'options' => [
                                'enctype' => 'multipart/form-data',
                            ],
                                ]
                );
				?>  
					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'product_name')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'product_code')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'category_id')->dropDownList($categoryData); ?>
							</div>
						</div>
					</div>
					<div class="row">	
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'scheme_applicable')->dropDownList(['' => 'Select Scheme Applicable','Yes' => 'Yes', 'No' => 'No']); ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'product_type_id')->dropDownList($productTypeData); ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'product_of_id')->dropDownList($productOfData); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'composition_id')->dropDownList($compositionData); ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'expiry_applicable')->dropDownList(['' => 'Select Expiry Applicable','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'showHideOpeningFields($(this));']); ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'not_opening_quantity')->textInput(); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'not_opening_price')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'not_opening_amount')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'status')->dropDownList(['' => 'Select Status','Active' => 'Active', 'Inactive' => 'Inactive']); ?>
							</div>
						</div>
					</div>
					<div class="row" id="opening_fields" style="display:none;">
						<div class="col-sm-2">
							<div class="form-group">
								<?= $form->field($model, 'opening_batch_no')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-2">
							<div class="form-group">
								<?= $form->field($model, 'opening_expiry')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-2">
							<div class="form-group">
								<?= $form->field($model, 'opening_quantity')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'opening_rate')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'opening_amount')->textInput(); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'product_used_for_id')->dropDownList($productUsedForData); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'product_packing_unit_id')->dropDownList($productUnitData); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'alternate_units')->dropDownList(['' => 'Select Unit','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'showHideCon($(this));']); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group" id="conversion" style="display:none;">
								<?= $form->field($model, 'conversion')->textInput(); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'standard_rate')->dropDownList(['' => 'Select Standard Rate','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'showHidePrice($(this));']); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group productPrice" style="display:none;">
								<?= $form->field($model, 'seling_price')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group productPrice" style="display:none;">
								<?= $form->field($model, 'mrp')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group productPrice" style="display:none;">
								<?= $form->field($model, 'purchase_price')->textInput(); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'applicability_of_differ_quantity')->dropDownList(['' => 'Select Applicability','Yes' => 'Yes', 'No' => 'No']); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'gst_applicable')->dropDownList(['' => 'Select GST Applicable','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'showHideGST($(this));']); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group customerGst" style="display:none;">
								<?= $form->field($model, 'gst_rate')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group customerGst" style="display:none;">
								<?= $form->field($model, 'hsn_code')->textInput(); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group" style="float:left;">
								<?= $form->field($model, 'image')->fileInput(['id' => 'fileId']); ?>
							</div>
							<div style="float:left;margin-top:25px;"><input type="button" value="Upload" class="btn btn-primary" onClick="return uploadFileImg('fileId','divId','imgSrc');"></div><br/>
							<div id="divId"></div>
							<input type="hidden" name="upload_file" class="divId" value="<?= !empty($model->image) ? $model->image : ''; ?>">
						</div>
						<div class="col-sm-6">
							<div class="form-group" style="border: 1px solid #ddd;box-shadow: 2px 1px 6px -1px;float:left;margin-left:20px;" id="imgVal">
								<img src="<?= !empty($model->image) ? FILE_URL . $model->image : BASE_URL.'images/product-no.png'; ?>" width="145" height="100" id="imgSrc"/>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group">
									 <?= Html::submitButton('Update', ['class' => 'btn btn-primary', 'name' => 'create-button']) ?>
									 
									 <?= Html::a('Cancel', ['/product-master'], ['class' => 'btn btn-danger']) ?>
								</div>
							</div>
						</div>
					</div>
				</div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>
<script>
var obj = $("#productmaster-alternate_units");
var obj2 = $("#productmaster-standard_rate");
var obj3 = $("#productmaster-gst_applicable");
showHideCon(obj);
showHidePrice(obj2);
showHideGST(obj3);
</script>
