<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'Product Of List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>product-master/create-product-of" title="Create Product Of">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'name_of_brand',
						'value' => 'name_of_brand',
						'filter' => true,
					],
					[
						'attribute' => 'related_to',
						'value' => function($model){
							return $model->getBookName($model->related_to);
						},
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'value' => 'status',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
						'buttons' => [
							'update' => function ($url, $searchModel) {
								return Html::a('<span class="glyphicon glyphicon-pencil"></span>', $url, [
											'title' => Yii::t('app', 'lead-update'),
								]);
							}

						  ],
						  'urlCreator' => function ($action, $searchModel, $key, $index) {
							if ($action === 'update') {
								$url ='create-product-of?id='.$searchModel->id;
								return $url;
							}
						}
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>