<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'Product Master List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>product-master/create" title="Create Product">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'product_name',
						'value' => 'product_name',
						'filter' => true,
					],
					[
						'attribute' => 'product_code',
						'value' => 'product_code',
						'filter' => true,
					],
					[
						'attribute' => 'category_id',
						'value' => function($model){
							return $model->getCategoryName($model->category_id);
						},
						'filter' => true,
					],
					[
						'attribute' => 'product_type_id',
						'value' => function($model){
							return $model->getProductTypeName($model->product_type_id);
						},
						'filter' => true,
					],
					[
						'attribute' => 'composition_id',
						'value' => function($model){
							return $model->getCompositionName($model->composition_id);
						},
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'value' => 'status',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>