<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Create Own Master Module';
$this->params['breadcrumbs'][] = $this->title;

?>
<style>
.lice{display:none;}
#number_of_licenses{display:none;}
#gst_no{display:none;}
</style>
<div class="col-lg-10 col-lg-offset-1 mainDiv">
    <div class=" panel-default table-bordered">
         <div class="panel-heading">
            <?php echo $this->title ?>
            <div class="menuLink">
                <a href="<?php echo BASE_URL; ?>ownmaster" title="Own Master Module List">
                    <i class="fa fa-list-ul fa-fw" style="font-size: 18px !important;"></i>
                </a>
            </div>
        </div>
        <div class="panel-body">
			<div class="form-container">
				<div style="text-align:center;width:100%;color:red;margin-top:10px;"><?= !empty($error) ? $error : ''; ?></div>
                <?php
                $form = ActiveForm::begin([
                            'id' => 'content_form',
                            'options' => [
                                'enctype' => 'multipart/form-data',
                            ],
                                ]
                );
				?>  
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'name_of_company')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'is_primary_company')->dropDownList(['Yes' => 'Yes', 'No' => 'No']); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'email_id')->textInput(['autocomplete' => 'off']) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'contact_no')->textInput(['maxlength' => 11]) ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'alt_contact_no')->textInput(['maxlength' => 11]) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'state_code')->dropDownList($stateData, ['onChange' => 'getStateCode();']); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'password')->passwordInput(); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'confirm_password')->passwordInput(); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<?= $form->field($model, 'address')->textarea(['rows' => 3]); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'bank_name')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'account_no')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'ifsc_code')->textInput(); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'branch_name')->textInput(); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'gst_applicable')->dropDownList(['' => 'Select Gst Applicable','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'getGstVal();']); ?>
							</div>
						</div>
						<div class="col-sm-6" id="gst_no">
							<div class="form-group">
								<?= $form->field($model, 'gst_no')->textInput() ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'is_licenses_applicable')->dropDownList(['' => 'Select Licenses Applicable','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'getLicenseVal();']); ?>
							</div>
						</div>	
						<div class="col-sm-6" id="number_of_licenses">
							<div class="form-group">
								<?= $form->field($model, 'number_of_licenses')->dropDownList(['' => 'Select Number of Licenses','1' => '1', '2' => '2', '3' => '3', '4' => '4'], ['onChange' => 'getLicense();']); ?>
							</div>
						</div>	
					</div>
					<div class="row">
						<div class="col-sm-3 lice" id="lice_1">
							<div class="form-group">
								<?= $form->field($model, 'licenses_number1')->textInput() ?>
							</div>
						</div>	
						<div class="col-sm-3 lice" id="lice_2">
							<div class="form-group">
								<?= $form->field($model, 'licenses_number2')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-3 lice" id="lice_3">
							<div class="form-group">
								<?= $form->field($model, 'licenses_number3')->textInput() ?>
							</div>
						</div>	
						<div class="col-sm-3 lice" id="lice_4">
							<div class="form-group">
								<?= $form->field($model, 'licenses_number4')->textInput() ?>
							</div>
						</div>	
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'invoice_design')->dropDownList(['' => 'Select Invoice Design','Design' => 'Design 1', 'File' => 'Design 2']) ?>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'invoice_series')->dropDownList(['' => 'Select Invoice Series','Text' => 'Series 1', 'File' => 'Series 2']) ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-2">
							<div class="form-group">
								<?= $form->field($model, 'is_logo')->radioList(['Yes' => 'Yes', 'No' => 'No'], ['itemOptions' => [ 'onClick'=>'getLogoFields2()']]) ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group" style="display:none;" id="logoField3">
								<?= $form->field($model, 'logo_type')->dropDownList(['' => 'Select logo type','Text' => 'Text', 'File' => 'File'], ['onChange' => 'getLogoFields3();']) ?>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group" style="display:none;" id="logoField1">
								<?= $form->field($model, 'logo_text')->textInput(['maxlength' => 2]) ?>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group" style="display:none;" id="logoField2">
								<?= $form->field($model, 'logo_file')->fileInput() ?>      
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group">
									 <?= Html::submitButton('Create', ['class' => 'btn btn-primary', 'name' => 'create-button']) ?>
									 
									 <?= Html::a('Cancel', ['/ownmaster'], ['class' => 'btn btn-danger']) ?>
								</div>
							</div>
						</div>
					</div>
				</div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>

<link href="<?= BASE_URL; ?>css/select2.min.css" rel="stylesheet" />
<script src="<?= BASE_URL; ?>js/select2.min.js"></script>
<script type="text/javascript">
$(document).ready(function() {
	$.noConflict();
	$("#ownmaster-state_code").select2().on("change", function (e) {
		getStateCode();
	});
});

function getLogoFields2(){
	var radioV = $('input[name="Ownmaster[is_logo]"]:checked').val();
	if(radioV == "Yes"){
		$("#logoField3").show();
	}else if(radioV == "No"){
		$("#logoField3").hide();
	}
}

function getGstVal(){
	var dropdownV = $('#ownmaster-gst_applicable :selected').val();
	if(dropdownV == "Yes"){
		$("#gst_no").show();
	}else if(dropdownV == "No"){
		$("#gst_no").hide();
	}
}

function getLicenseVal(){
	var dropdownV = $('#ownmaster-is_licenses_applicable :selected').val();
	if(dropdownV == "Yes"){
		$("#number_of_licenses").show();
	}else if(dropdownV == "No"){
		$("#number_of_licenses").hide();
	}
}

function getLogoFields3(){
	var dropdownV = $('#ownmaster-logo_type :selected').val();
	if(dropdownV == "File"){
		$("#logoField1").hide();
		$("#logoField2").show();
	}else if(dropdownV == "Text"){
		$("#logoField2").hide();
		$("#logoField1").show();
	}else{
		$("#logoField1").hide();
		$("#logoField2").hide();
	}
}

function getLicense(){
	var getVal = $('#ownmaster-number_of_licenses :selected').val();
	if(getVal != ""){
		$(".lice").hide();
		for(var i=1; i<=getVal; i++){
			$("#lice_" + i).show();
		}
	}else{
		$(".lice").hide();
	}
}
</script>
