<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'Farmer Master List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>farmer-master/create" title="Create Farmer Master">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'name_of_farmer',
						'value' => 'name_of_farmer',
						'filter' => true,
					],
					[
						'attribute' => 'farmer_type',
						'value' => function($model){
							return $model->getFarmerTypeName($model->farmer_type);
						},
						'filter' => true,
					],
					[
						'attribute' => 'contact_no',
						'value' => 'contact_no',
						'filter' => true,
					],
					[
						'attribute' => 'space',
						'value' => 'space',
						'filter' => true,
					],
					[
						'attribute' => 'address',
						'value' => 'address',
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'value' => 'status',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>