<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Create Farmer Master';
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="col-lg-10 col-lg-offset-1 mainDiv">
    <div class=" panel-default table-bordered">
         <div class="panel-heading">
            <?php echo $this->title ?>
            <div class="menuLink">
                <a href="<?php echo BASE_URL; ?>farmer-master" title="Farmer Master List">
                    <i class="fa fa-list-ul fa-fw" style="font-size: 18px !important;"></i>
                </a>
            </div>
        </div>
        <div class="panel-body">
			<div class="form-container">
                <?php
                $form = ActiveForm::begin([
                            'id' => 'content_form',
                            'options' => [
                                'enctype' => 'multipart/form-data',
                            ],
                                ]
                );
				?>  
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'name_of_farmer')->textInput(["onKeyup" => "viewFarmername()"]) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'area_id')->dropDownList($areaData) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'farmer_type')->dropDownList($farmerType) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'contact_no')->textInput(['maxlength' => 11]) ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group field-farmermaster-name_of_farmer required">
									<label>Name for display :- <span id="farmerName"></span></label>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<?= $form->field($model, 'address')->textarea(['rows' => 3]); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'space')->textInput(['maxlength' => 11]) ?>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'status')->dropDownList(['' => 'Select Status', 'Active' => 'Active', 'Inactive' => 'Inactive']); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group" style="float:left;">
								<?= $form->field($model, 'image')->fileInput(['id' => 'fileId']); ?>
							</div>
							<div style="float:left;margin-top:25px;"><input type="button" value="Upload" class="btn btn-primary" onClick="return uploadFileImg('fileId','divId','imgSrc');"></div><br/>
							<div id="divId"></div>
							<input type="hidden" name="upload_file" class="divId">
						</div>
						<div class="col-sm-6">
							<div class="form-group" style="border: 1px solid #ddd;box-shadow: 2px 1px 6px -1px;float:left;margin-left:20px;" id="imgVal">
								<img src="<?= BASE_URL; ?>images/no-profile.jpg" width="145" height="130" id="imgSrc"/>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group">
									 <?= Html::submitButton('Create', ['class' => 'btn btn-primary', 'name' => 'create-button']) ?>
									 
									 <?= Html::a('Cancel', ['/farmer-master'], ['class' => 'btn btn-danger']) ?>
								</div>
							</div>
						</div>
					</div>
				</div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>

<link href="<?= BASE_URL; ?>css/select2.min.css" rel="stylesheet" />
<script src="<?= BASE_URL; ?>js/select2.min.js"></script>
<script type="text/javascript">
$(document).ready(function() {
	$.noConflict();
	$("#ownmaster-state_code").select2().on("change", function (e) {
		getStateCode();
	});
});
</script>
