<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'Expenses List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>expenses/create" title="Create Expenses">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'sr_no',
						'value' => 'sr_no',
						'filter' => true,
					],
					[
						'attribute' => 'expenses_id',
						'value' => function($model){
							return $model->getExpenseName($model->expenses_id);
						},
						'filter' => true,
					],
					[
						'attribute' => 'amount',
						'value' => 'amount',
						'filter' => true,
					],
					[
						'attribute' => 'date',
						'value' => 'date',
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'value' => 'status',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>