<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Update Customer Master';
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="col-lg-10 col-lg-offset-1 mainDiv">
    <div class=" panel-default table-bordered">
         <div class="panel-heading">
            <?php echo $this->title ?>
            <div class="menuLink">
                <a href="<?php echo BASE_URL; ?>customer-master" title="Customer Master List">
                    <i class="fa fa-list-ul fa-fw" style="font-size: 18px !important;"></i>
                </a>
            </div>
        </div>
        <div class="panel-body">
			<div class="form-container">
                <?php
                $form = ActiveForm::begin([
                            'id' => 'content_form',
                            'options' => [
                                'enctype' => 'multipart/form-data',
                            ],
                                ]
                );
				?>  
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'name')->textInput(["onKeyup" => "viewCustomername()"]) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'customer_code')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'customer_type')->dropDownList($customerType); ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'area_id')->dropDownList($areaData); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group field-states-p_code required has-success">
									<label class="control-label"><b>View Customer :-</b> <span id="viewCustomer"></span></label>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'email_id')->textInput(['autocomplete' => 'off', 'readonly' => 'readonly']) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'contact_no')->textInput(['maxlength' => 11]) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'whatsapp_contact_no')->textInput(['maxlength' => 11]) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'aadhaar_card_no')->textInput(['autocomplete' => 'off']) ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'pan_card_no')->textInput() ?>
							</div>
						</div>	
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'opening_balance')->textInput(['autocomplete' => 'off']) ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'password')->passwordInput() ?>
							</div>
						</div>
						<div class="col-sm-3">
							<div class="form-group">
								<?= $form->field($model, 'confirm_password')->passwordInput() ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<?= $form->field($model, 'address')->textarea(['rows' => 3]); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'staff_assign_id')->dropDownList($staffData); ?>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'maximum_limit')->dropDownList(['' => 'Select Maximum Limit','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'showHideMlimit($(this).val());']); ?>
							</div>
						</div>
					</div>
					<div class="row" id="mlimit" style="display:none;">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'vegetable')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'clothing')->textInput() ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'gst_applicable')->dropDownList(['' => 'Select Gst Applicable','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'showHideGST($(this).val());']); ?>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group" id="customerGst" style="display:none;">
								<?= $form->field($model, 'gst_no')->textInput() ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'is_licenses_applicable')->dropDownList(['' => 'Select Licenses Applicable','Yes' => 'Yes', 'No' => 'No'], ['onChange' => 'showHideLicense($(this).val());']); ?>
							</div>
						</div>	
						<div class="col-sm-6">
							<div class="form-group" id="customerLicense" style="display:none;">
								<?= $form->field($model, 'license_no')->dropDownList(['' => 'Select Licenses','Yes' => 'Yes', 'No' => 'No']); ?>
							</div>
						</div>	
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'power_to_join_farmer')->dropDownList(['' => 'Select','Yes' => 'Yes', 'No' => 'No']); ?>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group">
								<?= $form->field($model, 'status')->dropDownList(['Active' => 'Active', 'Inactive' => 'Inactive']); ?>
							</div>
						</div>	
					</div>
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group" style="float:left;">
								<?= $form->field($model, 'photo')->fileInput(['id' => 'fileId']); ?>
							</div>
							<div style="float:left;margin-top:25px;"><input type="button" value="Upload" class="btn btn-primary" onClick="return uploadFileImg('fileId','divId','imgSrc');"></div><br/>
							<div id="divId"></div>
							<input type="hidden" name="upload_file" class="divId" value="<?= !empty($model->photo) ? $model->photo : ''; ?>">
						</div>
						<div class="col-sm-6">
							<div class="form-group" style="border: 1px solid #ddd;box-shadow: 2px 1px 6px -1px;float:left;margin-left:20px;" id="imgVal">
								<img src="<?= !empty($model->photo) ? FILE_URL . $model->photo : BASE_URL.'images/no-profile.jpg'; ?>" width="145" height="100" id="imgSrc"/>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group">
									 <?= Html::submitButton('Update', ['class' => 'btn btn-primary', 'name' => 'update-button']) ?>
									 
									 <?= Html::a('Cancel', ['/customer-master'], ['class' => 'btn btn-danger']) ?>
								</div>
							</div>
						</div>
					</div>
				</div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>

<link href="<?= BASE_URL; ?>css/select2.min.css" rel="stylesheet" />
<script src="<?= BASE_URL; ?>js/select2.min.js"></script>
<script type="text/javascript">
$(document).ready(function() {
	showHideMlimit('<?= $model->maximum_limit; ?>');
	showHideGST('<?= $model->gst_applicable; ?>');
	showHideLicense('<?= $model->is_licenses_applicable; ?>');
});
</script>
