<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'Customer Master List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>customer-master/create" title="Create Customer Master">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'name',
						'value' => 'name',
						'filter' => true,
					],
					[
						'attribute' => 'email_id',
						'value' => 'email_id',
						'filter' => true,
					],
					[
						'attribute' => 'contact_no',
						'value' => 'contact_no',
						'filter' => true,
					],
					[
						'attribute' => 'aadhaar_card_no',
						'value' => 'aadhaar_card_no',
						'filter' => true,
					],
					[
						'attribute' => 'pan_card_no',
						'value' => 'pan_card_no',
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'format' => 'raw',
						'contentOptions' => ['style' => 'width:110px;'],
						'value' => function($model){
							$check = "";
							if($model->status == "Active"){
								$check = "checked='checked'";	
							}
							return '<input type="checkbox" table="ac_own_master_data_module" class="statusBtn" '.$check.' idVal="'.$model->id.'">';
						},
						'filter' => false,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>