<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'CD Rate List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>cdrate/create" title="Create CD Rate">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'cd_rate',
						'value' => 'cd_rate',
						'filter' => true,
					],
					[
						'attribute' => 'validity_from',
						'value' => function($model){
							return Utility::getDateFormat($model->validity_from);
						},
						'filter' => true,
					],
					[
						'attribute' => 'validity_to',
						'value' => function($model){
							return Utility::getDateFormat($model->validity_to);
						},
						'filter' => true,
					],
					[
						'attribute' => 'conditions',
						'value' => 'conditions',
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'value' => 'status',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>