<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Update Case In hand Master';
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="col-lg-10 col-lg-offset-1 mainDiv">
    <div class=" panel-default table-bordered">
         <div class="panel-heading">
            <?php echo $this->title ?>
            <div class="menuLink">
                <a href="<?php echo BASE_URL; ?>case-in-hand" title="Case In Hand Master List">
                    <i class="fa fa-list-ul fa-fw" style="font-size: 18px !important;"></i>
                </a>
            </div>
        </div>
        <div class="panel-body">
			<div class="form-container">
                <?php
                $form = ActiveForm::begin([
                            'id' => 'content_form',
                            'options' => [
                                'enctype' => 'multipart/form-data',
                            ],
                                ]
                );
				?>  
					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'name')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'opening_balance')->textInput() ?>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'related_to')->dropDownList($owners); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<?= $form->field($model, 'status')->dropDownList(['' => 'Select Status', 'Active' => 'Active', 'Inactive' => 'Inactive']); ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="form-group">
								<div class="form-group">
									 <?= Html::submitButton('Update', ['class' => 'btn btn-primary', 'name' => 'update-button']) ?>
									 
									 <?= Html::a('Cancel', ['/case-in-hand'], ['class' => 'btn btn-danger']) ?>
								</div>
							</div>
						</div>
					</div>
				</div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>