<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;
use backend\models\VehicleNumber;

$this->title = 'Case In Hand Master';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>case-in-hand/create" title="Create Case In Hand">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'name',
						'value' => 'name',
						'filter' => true,
					],
					[
						'attribute' => 'opening_balance',
						'value' => 'opening_balance',
						'filter' => true,
					],
					[
						'attribute' => 'related_to',
						'value' => function($model){
							$modelV = new VehicleNumber();
							return $modelV->getOwnerName($model->related_to);
						},
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'value' => 'status',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>