<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\ArrayHelper;
use backend\models\Utility;

$this->title = 'Bank Master List';
?>
<div class="panel panel-default mainDiv">
	<div class="panel-heading">
		<?php echo $this->title; ?>
		<div class="menuLink">
			<a href="<?php echo BASE_URL; ?>bank-master/create" title="Create Bank Master">
				<i class="fa fa-plus-circle fa-fw" style="font-size: 18px !important;"></i>
			</a>
		</div>
	</div>
	<div class="panel-body">
		<div class="table-responsive">
			
			<?=
			GridView::widget([
				'dataProvider' => $dataProvider,
				'filterModel' => $searchModel,
				'summary' => FALSE,
				'columns' => [

					[
						'attribute' => 'bank_name',
						'value' => 'bank_name',
						'filter' => true,
					],
					[
						'attribute' => 'account_no',
						'value' => 'account_no',
						'filter' => true,
					],
					[
						'attribute' => 'ifsc_code',
						'value' => 'ifsc_code',
						'filter' => true,
					],
					[
						'attribute' => 'branch_name',
						'value' => 'branch_name',
						'filter' => true,
					],
					[
						'attribute' => 'bank_related_to',
						'value' => function($model){
							return Utility::getBookName($model->bank_related_to);
						},
						'filter' => true,
					],
					[
						'attribute' => 'status',
						'value' => 'status',
						'filter' => true,
					],
					[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{update}',
					],
					
					
				],
			]);
			?>
			
		</div>
	</div>
</div>