<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class VehicleOwner extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_vehicle_owner';
    }

	public function rules() {
        return [
            [['name', 'address', 'pan_card_no', 'contact_number', 'status'], 'required'],
			[['name', 'address', 'pan_card_no', 'contact_number', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name' => 'Name',
            'address' => 'Address',
            'pan_card_no' => 'Pan Card Number',
            'contact_number' => 'Contact Number',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach VehicleOwner data and listing
    public function search($params) {
		$query = VehicleOwner::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'pan_card_no', $this->pan_card_no]);
		$query->andFilterWhere(['like', 'name', $this->name]);
		$query->andFilterWhere(['like', 'address', $this->address]);
		$query->andFilterWhere(['like', 'contact_number', $this->contact_number]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }

}
