<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class VehicleNumber extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_vehicle_number';
    }

	public function rules() {
        return [
            [['vehicle_number', 'driver_id', 'owner_id', 'status'], 'required'],
			[['vehicle_number', 'driver_id', 'owner_id', 'model', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'vehicle_number' => 'Vehicle Number',
            'driver_id' => 'Driver Name',
            'owner_id' => 'Owner Name',
            'model' => 'Model',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach VehicleNumber data and listing
    public function search($params) {
		$query = VehicleNumber::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'owner_id', $this->owner_id]);
		$query->andFilterWhere(['like', 'vehicle_number', $this->vehicle_number]);
		$query->andFilterWhere(['like', 'driver_id', $this->driver_id]);
		$query->andFilterWhere(['like', 'model', $this->model]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }
	
	// For get drivers
	public function getDrivers(){
		$connection = \Yii::$app->db;	
		$sql = "select id,name from map_driver where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Driver");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name'];
			}
		}
		return $array;
	}
	
	// For get vehicle owner
	public function getVehicleOwner(){
		$connection = \Yii::$app->db;	
		$sql = "select id,name from map_vehicle_owner where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Owner");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name'];
			}
		}
		return $array;
	}
	
	// For get driver name
	public function getDriverName($id){
		$connection = \Yii::$app->db;	
		$sql = "select name from map_driver where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['name'])){
			return $data[0]['name'];
		}
	}
	
	// For get owner name
	public function getOwnerName($id){
		$connection = \Yii::$app->db;	
		$sql = "select name from map_vehicle_owner where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['name'])){
			return $data[0]['name'];
		}
	}

}
