<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;
use yii\helpers\ArrayHelper;
use backend\models\States;

class Utility extends \yii\db\ActiveRecord {
	
	// For get all states
	public function getStates(){
		$stateData = ArrayHelper::map(States::find()->orderBy(['p_name' => SORT_ASC])->all(), 'p_code', 'p_name');
		$stateArray = array();
		if(!empty($stateData)){
			foreach($stateData as $key => $name){
				$key2 = $key;
				if($key < 10){
					$key2 = '0'.$key;
				}
				$stateArray[$key] = $name.' - '.$key2;	
			}
		}
		return $stateArray;
	}
	
	// For get state html data
	public function getStatesHtml($ledgerData){
		$stateData = ArrayHelper::map(States::find()->orderBy(['p_name' => SORT_ASC])->all(), 'p_code', 'p_name');
		$stateArray = '<option value="">Select State</option>';
		if(!empty($stateData)){
			foreach($stateData as $key => $value){
				$key2 = $key;
				$select = '';
				if($key < 10){
					$key2 = '0'.$key;
				}if(!empty($ledgerData['state_code']) && $ledgerData['state_code'] == $key){
					$select = 'selected="selected"';	
				}
				
				$stateArray .= '<option value="'.$key.'" '.$select.'>'.$value.' - '.$key2.'</option>';
			}
		}
		
		return $stateArray;
	}
	
	// For get state name
	public static function getStateName($id){
		$data = States::find()->where(['p_code' => $id])->asArray()->one();
		if(!empty($data)){
			return $data;	
		}
	}
	
	// For get date format
	public static function getDateFormat($date){
		return date("d M Y", strtotime($date));
	}
	
	// For get book name from id
	public static function getBookName($id){
		$connection = \Yii::$app->db;	
		$sql = "select name_of_books from map_book_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['name_of_books'])){
			return $data[0]['name_of_books'];
		}
	}
	
	// For get book name from id
	public static function getProductName($id){
		$connection = \Yii::$app->db;	
		$sql = "select product_name from map_product_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['product_name'])){
			return $data[0]['product_name'];
		}
	}
	
}
