<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class States extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'ac_states';
    }
	
	public function rules() {
        return [
            [['p_name', 'p_code'], 'required'],
			[['p_name', 'p_code'], 'unique'],
			[['p_name', 'status', 'p_code'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'p_code' => 'State Code',
            'p_name' => 'State Name',
            'p_status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach state
    public function search($params) {
		$query = States::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }

        $query->andFilterWhere(['like', 'p_name', $this->p_name]);
        $query->andFilterWhere(['like', 'p_code', $this->p_code]);
		$query->andFilterWhere(['like', 'p_status', $this->p_status]);
		
        return $dataProvider;
    }
	
}
