<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class StaffMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_staff_master';
    }

	public function rules() {
        return [
            [['own_master_id', 'address', 'email_id', 'contact_no', 'name_of_staff', 'password', 'confirm_password', 'area_id', 'aadhaar_card_no', 'pan_card_no', 'status'], 'required'],
			[['email_id'], 'email'],
			[['email_id', 'aadhaar_card_no', 'pan_card_no'], 'unique'],
			[['contact_no', 'aadhaar_card_no', 'pan_card_no'], 'number'],
			['confirm_password', 'compare', 'compareAttribute'=>'password', 'message'=>"Passwords do not match" ],
			[['own_master_id', 'address', 'email_id', 'contact_no', 'name_of_staff', 'password', 'confirm_password', 'area_id', 'aadhaar_card_no', 'pan_card_no', 'status', 'whatsapp_contact_no', 'photo', 'staff_rights'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'own_master_id' => 'Name of Company',
            'name_of_staff' => 'Name of Staff',
            'address' => 'Address',
            'email_id' => 'Email Id',
            'contact_no' => 'Contact Number',
            'whatsapp_contact_no' => 'Whatsapp Contact Number',
            'password' => 'Password',
			'confirm_password' => 'Confirm Password',
			'area_id' => 'Area',
            'aadhaar_card_no' => 'Aadhaar Card Number',
            'pan_card_no' => 'Pan Card Number',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach StaffMaster data and listing
    public function search($params) {
		$query = StaffMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'own_master_id', $this->own_master_id]);
		$query->andFilterWhere(['like', 'email_id', $this->email_id]);
		$query->andFilterWhere(['like', 'contact_no', $this->contact_no]);
		$query->andFilterWhere(['like', 'name_of_staff', $this->name_of_staff]);
		$query->andFilterWhere(['like', 'aadhaar_card_no', $this->aadhaar_card_no]);
		$query->andFilterWhere(['like', 'pan_card_no', $this->pan_card_no]);
		
        return $dataProvider;
    }
	
	// For get area data
	public function getAreaData(){
		$connection = \Yii::$app->db;	
		$sql = "select id,name_of_master from map_area_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Area");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name_of_master'];
			}
		}
		return $array;
	}
	
	// For get company data
	public function getCompanyData(){
		$connection = \Yii::$app->db;	
		$sql = "select id,name_of_company from map_own_master_data_module where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Company");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name_of_company'];
			}
		}
		return $array;
	}
	
	// For get staff data
	public function getStaffData(){
		$connection = \Yii::$app->db;	
		$sql = "select id,name_of_staff from map_staff_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Staff Name");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name_of_staff'];
			}
		}
		return $array;
	}
	
	// For get company name
	public function getCompanyName($id){
		$connection = \Yii::$app->db;	
		$sql = "select name_of_company from map_own_master_data_module where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['name_of_company'])){
			return $data[0]['name_of_company'];
		}
	}

}
