<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class Scheme extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_scheme_set';
    }

	public function rules() {
        return [
            [['scheme_name', 'validity_from', 'validity_to', 'total_quantity', 'product_id', 'status'], 'required'],
			[['scheme_name', 'validity_from', 'validity_to', 'total_quantity', 'product_id', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'cd_rate' => 'Cd Rate',
            'validity_from' => 'Validity From',
            'validity_to' => 'Validity To',
            'conditions' => 'Conditions',
            'product_id' => 'Applicable',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach Scheme data and listing
    public function search($params) {
		$query = Scheme::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'scheme_name', $this->scheme_name]);
		$query->andFilterWhere(['like', 'validity_to', $this->validity_to]);
		$query->andFilterWhere(['like', 'validity_from', $this->validity_from]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }

}
