<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class SalesReturns extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_sales_returns';
    }

	public function rules() {
        return [
            [['books_id', 'additional_lines', 'product_id', 'amount', 'rate', 'customer_name', 'quantity', 'sr_no', 'status'], 'required'],
			[['books_id', 'additional_lines', 'product_id', 'amount', 'rate', 'remarks', 'customer_name', 'quantity', 'books_order', 'date', 'status', 'sr_no', 'alt_quantity', 'vehicle_no'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'books_id' => 'Books Name',
            'product_id' => 'Product name',
            'alt_quantity' => 'Alternate Quantity',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach SalesReturns data and listing
    public function search($params) {
		$query = SalesReturns::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'cd_rate', $this->cd_rate]);
		$query->andFilterWhere(['like', 'validity_to', $this->validity_to]);
		$query->andFilterWhere(['like', 'sr_no', $this->sr_no]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }

}
