<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class Sales extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_sales';
    }

	public function rules() {
        return [
            [['books_id', 'additional_lines', 'product_id', 'amount', 'rate', 'remarks', 'customer_name', 'quantity', 'sr_no'], 'required'],
			[['books_id', 'additional_lines', 'product_id', 'amount', 'rate', 'remarks', 'customer_name', 'quantity', 'books_order', 'date', 'status', 'vehicle_no', 'alt_quantity', 'gst', 'total_amount', 'gst_amount'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'books_id' => 'Books Name',
            'product_id' => 'Product name',
            'alt_quantity' => 'Alternate Quantity',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach Sales data and listing
    public function search($params) {
		$query = Sales::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'sr_no', $this->sr_no]);
		$query->andFilterWhere(['like', 'customer_name', $this->customer_name]);
		$query->andFilterWhere(['like', 'books_id', $this->books_id]);
		$query->andFilterWhere(['like', 'product_id', $this->product_id]);
		$query->andFilterWhere(['like', 'quantity', $this->quantity]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		$query->andFilterWhere(['like', 'date', $this->date]);
		
        return $dataProvider;
    }
	
	// For get book name from id
	public function getBookName($id){
		$connection = \Yii::$app->db;	
		$sql = "select name_of_books from map_book_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['name_of_books'])){
			return $data[0]['name_of_books'];
		}
	}
	
	// For get book name from id
	public function getProductName($id){
		$connection = \Yii::$app->db;	
		$sql = "select product_name from map_product_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['product_name'])){
			return $data[0]['product_name'];
		}
	}

}
