<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class PurchaseReturns extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_purchase_returns';
    }

	public function rules() {
        return [
            [['books_id', 'date', 'product_id', 'sr_no', 'customer_name', 'quantity', 'gst', 'amount_confirm', 'amount', 'vehicle_number'], 'required'],
			[['books_id', 'additional_lines', 'product_id', 'amount', 'rate', 'remarks', 'customer_name', 'quantity', 'date', 'sr_no', 'amount_confirm', 'gst', 'vehicle_number'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'books_id' => 'Books Name',
            'product_id' => 'Product name',
            'amount_confirm' => 'Amount Confirmation',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach PurchaseOrder data and listing
    public function search($params) {
		$query = PurchaseOrder::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'amount', $this->amount]);
		$query->andFilterWhere(['like', 'amount_confirm', $this->amount_confirm]);
		$query->andFilterWhere(['like', 'gst', $this->gst]);
		$query->andFilterWhere(['like', 'sr_no', $this->sr_no]);
		
        return $dataProvider;
    }

}
