<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class ProductUsedFor extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_product_used_for_master';
    }

	public function rules() {
        return [
            [['product_used_for', 'status'], 'required'],
            [['product_used_for'], 'unique'],
			[['product_used_for', 'status'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'product_used_for' => 'Product Used For',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach ProductUsedFor data and listing
    public function search($params) {
		$query = ProductUsedFor::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name_of_company', $this->name]);
		$query->andFilterWhere(['like', 'email_id', $this->email_id]);
		
        return $dataProvider;
    }

}
