<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class ProductPackingUnit extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_packing_unit_master';
    }

	public function rules() {
        return [
            [['product_packing_units', 'standards', 'status'], 'required'],
            [['product_packing_units'], 'unique'],
			[['product_packing_units', 'status', 'standards'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'product_packing_units' => 'Product Packing Units',
			'status' => 'Status',
			'standards' => 'Standards',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach ProductPackingUnit data and listing
    public function search($params) {
		$query = ProductPackingUnit::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'product_packing_units', $this->product_packing_units]);
		$query->andFilterWhere(['like', 'standards', $this->standards]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }

}
