<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class ProductOf extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_product_of_master';
    }

	public function rules() {
        return [
            [['name_of_brand', 'related_to', 'status'], 'required'],
            [['name_of_brand'], 'unique'],
			[['name_of_brand', 'status', 'related_to'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'name_of_brand' => 'Name of Brand',
			'related_to' => 'Related To',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach ProductOf data and listing
    public function search($params) {
		$query = ProductOf::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'name_of_brand', $this->name_of_brand]);
		$query->andFilterWhere(['like', 'related_to', $this->related_to]);
		$query->andFilterWhere(['like', 'status', $this->status]);
		
        return $dataProvider;
    }
	
	// For get books
	public function getBooks(){
		$connection = \Yii::$app->db;	
		$sql = "select id,name_of_books from map_book_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Books");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name_of_books'];
			}
		}
		return $array;
	}
	
	// For get products
	public function getProducts(){
		$connection = \Yii::$app->db;	
		$sql = "select id,product_name from map_product_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array(""=>"Select Product");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['product_name'];
			}
		}
		return $array;
	}
	
	// For get book name from id
	public function getBookName($id){
		$connection = \Yii::$app->db;	
		$sql = "select name_of_books from map_book_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['name_of_books'])){
			return $data[0]['name_of_books'];
		}
	}

}
