<?php

namespace backend\models;

use yii\data\ActiveDataProvider;
use yii\base\Model;
use Yii;

class ProductMaster extends \yii\db\ActiveRecord {

    public static function tableName() {
        return 'map_product_master';
    }

	public function rules() {
        return [
            [['product_name', 'product_code', 'expiry_applicable', 'scheme_applicable', 'standard_rate', 'category_id', 'product_type_id', 'product_of_id', 'composition_id', 'product_used_for_id', 'product_packing_unit_id', 'alternate_units', 'applicability_of_differ_quantity', 'gst_applicable', 'gst_rate', 'status'], 'required'],
			[['not_opening_quantity', 'not_opening_price', 'not_opening_amount'], 'number'],
			[['product_name', 'product_code', 'expiry_applicable', 'scheme_applicable', 'standard_rate', 'category_id', 'product_type_id', 'product_of_id', 'composition_id', 'product_used_for_id', 'product_packing_unit_id', 'alternate_units', 'applicability_of_differ_quantity', 'gst_applicable', 'gst_rate', 'opening_rate', 'image', 'status', 'hsn_code', 'seling_price', 'mrp', 'purchase_price', 'conversion', 'opening_batch_no', 'opening_expiry', 'opening_quantity', 'opening_amount'], 'safe']
        ];
    }

    public function attributeLabels() {
        return [
            'id' => 'Id',
            'not_opening_quantity' => 'Opening Quantity',
            'not_opening_price' => 'Opening Price',
            'not_opening_amount' => 'Opening Amount',
            'category_id' => 'Category',
            'product_type_id' => 'Product Type',
            'product_of_id' => 'Product Of',
            'composition_id' => 'Composition',
            'product_used_for_id' => 'Product Used For',
            'product_packing_unit_id' => 'Product Packing Unit',
			'standard_rate' => 'Standard Rate',
			'image' => 'Product Image',
			'hsn_code' => 'HSN Code',
			'opening_quantity' => 'Opening Quantity',
			'applicability_of_differ_quantity' => 'Applicability of Differ Quantity',
			'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'updated_by' => 'Updated By',
            'updated_on' => 'Updated On'
        ];
    }
	
	// For serach ProductMaster data and listing
    public function search($params) {
		$query = ProductMaster::find();
		$dataProvider = new ActiveDataProvider([
            'query' => $query,
			'pagination' => ['pageSize' => 20],
        ]);
        if (!($this->load($params))) {
            return $dataProvider;
        }
		
		$query->andFilterWhere(['like', 'product_name', $this->product_name]);
		$query->andFilterWhere(['like', 'opening_stock', $this->opening_stock]);
		$query->andFilterWhere(['like', 'product_code', $this->product_code]);
		$query->andFilterWhere(['like', 'standard_rate', $this->standard_rate]);
		$query->andFilterWhere(['like', 'opening_rate', $this->opening_rate]);
		
        return $dataProvider;
    }
	
	// For get category data
	public function getCategoryData(){
		$connection = \Yii::$app->db;	
		$sql = "select id,product_category from map_product_category_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array("" => "Select Category");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['product_category'];	
			}
		}
		return $array;
	}
	
	// For get product type data
	public function getProductType(){
		$connection = \Yii::$app->db;	
		$sql = "select id,product_type from map_product_type_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array("" => "Select Product Type");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['product_type'];	
			}
		}
		return $array;
	}
	
	// For get product of data
	public function getProductOf(){
		$connection = \Yii::$app->db;	
		$sql = "select id,name_of_brand from map_product_of_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array("" => "Select Product Of");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['name_of_brand'];	
			}
		}
		return $array;
	}
	
	// For get composition data
	public function getCompositionData(){
		$connection = \Yii::$app->db;	
		$sql = "select id,composition from map_composition_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array("" => "Select Composition");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['composition'];	
			}
		}
		return $array;
	}
	
	// For get product used for data
	public function getProductUsedFor(){
		$connection = \Yii::$app->db;	
		$sql = "select id,product_used_for from map_product_used_for_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array("" => "Select Product Used For");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['product_used_for'];	
			}
		}
		return $array;
	}
	
	// For get product product packing unit data
	public function getProductPackingUnit(){
		$connection = \Yii::$app->db;	
		$sql = "select id,product_packing_units from map_packing_unit_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		$array = array();
		$array = array("" => "Select Product Packing Unit");
		if(!empty($data)){
			foreach($data as $value){
				$array[$value['id']] = $value['product_packing_units'];	
			}
		}
		return $array;
	}
	
	// For get category name
	public function getCategoryName($id){
		$connection = \Yii::$app->db;	
		$sql = "select product_category from map_product_category_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['product_category'])){
			return $data[0]['product_category'];
		}
	}
	
	// For get product type
	public function getProductTypeName($id){
		$connection = \Yii::$app->db;	
		$sql = "select product_type from map_product_type_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['product_type'])){
			return $data[0]['product_type'];
		}
	}
	
	// For get composition
	public function getCompositionName($id){
		$connection = \Yii::$app->db;	
		$sql = "select composition from map_composition_master where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0]['composition'])){
			return $data[0]['composition'];
		}
	}
	
	// For get name
	public function getName($id,$table,$column){
		$connection = \Yii::$app->db;	
		$sql = "select $column from $table where id = :id";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":id", $id);
		$data = $command->queryAll();
		if(!empty($data[0][$column])){
			return $data[0][$column];
		}
	}
	
	// For get search data
	public function getProductData($searchFor, $keyword){
		$connection = \Yii::$app->db;	
		if($searchFor == "product"){
			$sql = "select * from map_product_master where product_name like '%$keyword%'";
			$command = $connection->createCommand($sql);
			$data = $command->queryAll();
			return $data;
		}else{
			if($searchFor == "usedFor"){
				$table = "map_product_used_for_master";
				$column = "product_used_for_id";
				$searchColumn = "product_used_for";
			}else if($searchFor == "composition"){
				$table = "map_composition_master";
				$column = "composition_id";
				$searchColumn = "composition";
			}else if($searchFor == "brand"){
				$table = "map_product_of_master";
				$column = "product_of_id";
				$searchColumn = "name_of_brand";
			}
			
			$sql = "select p.* from map_product_master p join $table s on (p.$column = s.id) where $searchColumn like '%$keyword%'";
			$command = $connection->createCommand($sql);
			$data = $command->queryAll();
			return $data;
		} 
	}
	
	// For get all product data
	public function getAllProductData($page,$page_records){
		$connection = \Yii::$app->db;	
		$start = $page_records * ($page - 1);
		$end = $page_records;
		$sql = "select * from map_product_master where status = 'Active' limit :start,:end";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":start", $start);
		$command = $command->bindParam(":end", $end);
		$data = $command->queryAll();
		return $data;
	}
	
	// For get all product data
	public function getAllProducts(){
		$connection = \Yii::$app->db;	
		$sql = "select id,product_name,product_code from map_product_master where status = 'Active'";
		$command = $connection->createCommand($sql);
		$data = $command->queryAll();
		return $data;
	}
	
	// For place order
	public function placeProductOrder($user_id){
		$connection = \Yii::$app->db;	
		$sql = "insert into map_place_order (user_id) value (:user_id)";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":user_id", $user_id);
		$command->execute();
		$place_order_id = Yii::$app->db->getLastInsertID();
		return $place_order_id;
	}
	
	// For place order
	public function placeOrder($product_id,$product_qty,$place_order_id){
		$connection = \Yii::$app->db;	
		$sql = "insert into map_product_order (place_order_id,product_id,product_qty) value (:place_order_id,:product_id,:product_qty)";
		$command = $connection->createCommand($sql);
		$command = $command->bindParam(":place_order_id", $place_order_id);
		$command = $command->bindParam(":product_id", $product_id);
		$command = $command->bindParam(":product_qty", $product_qty);
		$command->execute();
	}

}
